<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbAditivo
 *
 * @ORM\Table(name="agrega.tb_aditivo", indexes={@ORM\Index(name="IDX_67A9DD9D70AE7BF1", columns={"contrato_id"}), @ORM\Index(name="IDX_67A9DD9D35492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbAditivo
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_aditivo_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="data", type="date", nullable=true)
     */
    private $data;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataaditivo", type="datetime", nullable=true)
     */
    private $dataaditivo;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=true)
     */
    private $valor;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datavigencia", type="datetime", nullable=true)
     */
    private $datavigencia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tpaditivo", type="string", length=255, nullable=true)
     */
    private $tpaditivo;

    /**
     * @var \Agrega.tbContrato
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbContrato")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="contrato_id", referencedColumnName="id")
     * })
     */
    private $contrato;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
