<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbCliente
 *
 * @ORM\Table(name="agrega.tb_cliente", indexes={@ORM\Index(name="IDX_236CE33A35492110", columns={"usuarioatualizacao_id"}), @ORM\Index(name="IDX_236CE33A1BB76823", columns={"endereco_id"})})
 * @ORM\Entity
 */
class tbCliente
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_cliente_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="celular", type="string", length=255, nullable=true)
     */
    private $celular;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cnae", type="string", length=255, nullable=true)
     */
    private $cnae;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cnpjcpf", type="string", length=255, nullable=true)
     */
    private $cnpjcpf;

    /**
     * @var string|null
     *
     * @ORM\Column(name="contato", type="string", length=255, nullable=true)
     */
    private $contato;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datacadastro", type="date", nullable=true)
     */
    private $datacadastro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="email", type="string", length=255, nullable=true)
     */
    private $email;

    /**
     * @var string|null
     *
     * @ORM\Column(name="funcao", type="string", length=255, nullable=true)
     */
    private $funcao;

    /**
     * @var int|null
     *
     * @ORM\Column(name="inscricaoestadual", type="bigint", nullable=true)
     */
    private $inscricaoestadual;

    /**
     * @var int|null
     *
     * @ORM\Column(name="inscricaomunicipal", type="bigint", nullable=true)
     */
    private $inscricaomunicipal;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome", type="string", length=255, nullable=true)
     */
    private $nome;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacoes", type="string", length=501, nullable=true)
     */
    private $observacoes;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pendencia", type="string", length=255, nullable=true)
     */
    private $pendencia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="porteempresa", type="string", length=255, nullable=true)
     */
    private $porteempresa;

    /**
     * @var string|null
     *
     * @ORM\Column(name="rg", type="string", length=255, nullable=true)
     */
    private $rg;

    /**
     * @var string|null
     *
     * @ORM\Column(name="seguimento", type="string", length=255, nullable=true)
     */
    private $seguimento;

    /**
     * @var string|null
     *
     * @ORM\Column(name="setor", type="string", length=255, nullable=true)
     */
    private $setor;

    /**
     * @var string|null
     *
     * @ORM\Column(name="sigla", type="string", length=255, nullable=true)
     */
    private $sigla;

    /**
     * @var string|null
     *
     * @ORM\Column(name="status", type="string", length=255, nullable=true)
     */
    private $status;

    /**
     * @var string|null
     *
     * @ORM\Column(name="telefone", type="string", length=255, nullable=true)
     */
    private $telefone;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tipocliente", type="string", length=255, nullable=true)
     */
    private $tipocliente;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tipoindicacao", type="string", length=255, nullable=true)
     */
    private $tipoindicacao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="chavepix", type="string", length=255, nullable=true)
     */
    private $chavepix;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;

    /**
     * @var \Agrega.tbEndereco
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbEndereco")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="endereco_id", referencedColumnName="id")
     * })
     */
    private $endereco;


}
