<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbCombo
 *
 * @ORM\Table(name="agrega.tb_combo", indexes={@ORM\Index(name="IDX_1C5360C527EA48A0", columns={"id_tpcombo"}), @ORM\Index(name="IDX_1C5360C58A623FAB", columns={"alteradopor_id"}), @ORM\Index(name="IDX_1C5360C5859422DD", columns={"criadopor_id"})})
 * @ORM\Entity
 */
class tbCombo
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_combo_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="alteradoem", type="datetime", nullable=true)
     */
    private $alteradoem;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=true)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="criadoem", type="datetime", nullable=true)
     */
    private $criadoem;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=100, nullable=true)
     */
    private $descricao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaoanterior", type="string", length=255, nullable=true)
     */
    private $descricaoanterior;

    /**
     * @var int|null
     *
     * @ORM\Column(name="sequencial", type="bigint", nullable=true)
     */
    private $sequencial;

    /**
     * @var \Agrega.tbTpCombo
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbTpCombo")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_tpcombo", referencedColumnName="id")
     * })
     */
    private $idTpcombo;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="alteradopor_id", referencedColumnName="id")
     * })
     */
    private $alteradopor;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="criadopor_id", referencedColumnName="id")
     * })
     */
    private $criadopor;


}
