<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbContato
 *
 * @ORM\Table(name="agrega.tb_contato", indexes={@ORM\Index(name="IDX_14F4D35D35492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbContato
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_contato_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datacadastro", type="date", nullable=true)
     */
    private $datacadastro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="emailcontato", type="string", length=255, nullable=true)
     */
    private $emailcontato;

    /**
     * @var int|null
     *
     * @ORM\Column(name="idcliente", type="bigint", nullable=true)
     */
    private $idcliente;

    /**
     * @var int|null
     *
     * @ORM\Column(name="idfornecedor", type="bigint", nullable=true)
     */
    private $idfornecedor;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nomecontato", type="string", length=255, nullable=true)
     */
    private $nomecontato;

    /**
     * @var string|null
     *
     * @ORM\Column(name="setorcontato", type="string", length=255, nullable=true)
     */
    private $setorcontato;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tel1contato", type="string", length=255, nullable=true)
     */
    private $tel1contato;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tel2contato", type="string", length=255, nullable=true)
     */
    private $tel2contato;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
