<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbContatoRapido
 *
 * @ORM\Table(name="agrega.tb_contato_rapido", indexes={@ORM\Index(name="IDX_EE8BE6ED2A2DF2C6", columns={"atualizadorpor_id"}), @ORM\Index(name="IDX_EE8BE6ED859422DD", columns={"criadopor_id"})})
 * @ORM\Entity
 */
class tbContatoRapido
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_contato_rapido_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="alteradoem", type="datetime", nullable=true)
     */
    private $alteradoem;

    /**
     * @var string|null
     *
     * @ORM\Column(name="assunto", type="string", length=255, nullable=true)
     */
    private $assunto;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="criadoem", type="datetime", nullable=true)
     */
    private $criadoem;

    /**
     * @var string|null
     *
     * @ORM\Column(name="email", type="string", length=255, nullable=true)
     */
    private $email;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome", type="string", length=255, nullable=true)
     */
    private $nome;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacao", type="string", length=255, nullable=true)
     */
    private $observacao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="telefone", type="string", length=255, nullable=true)
     */
    private $telefone;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="atualizadorpor_id", referencedColumnName="id")
     * })
     */
    private $atualizadorpor;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="criadopor_id", referencedColumnName="id")
     * })
     */
    private $criadopor;


}
