<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbContrato
 *
 * @ORM\Table(name="agrega.tb_contrato", indexes={@ORM\Index(name="IDX_EBB618AEAE13E077", columns={"proposta_id"}), @ORM\Index(name="IDX_EBB618AE35492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbContrato
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_contrato_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="consideracoesfinais", type="string", length=1100, nullable=true)
     */
    private $consideracoesfinais;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataassinatura", type="datetime", nullable=true)
     */
    private $dataassinatura;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datavencimento", type="datetime", nullable=true)
     */
    private $datavencimento;

    /**
     * @var string|null
     *
     * @ORM\Column(name="formapagamento", type="string", length=255, nullable=true)
     */
    private $formapagamento;

    /**
     * @var string|null
     *
     * @ORM\Column(name="informacoesclausulas", type="string", length=1100, nullable=true)
     */
    private $informacoesclausulas;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nrcontrato", type="string", length=255, nullable=true)
     */
    private $nrcontrato;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacoesparcelas", type="string", length=255, nullable=true)
     */
    private $observacoesparcelas;

    /**
     * @var int|null
     *
     * @ORM\Column(name="quantidadeparcela", type="integer", nullable=true)
     */
    private $quantidadeparcela;

    /**
     * @var float|null
     *
     * @ORM\Column(name="saldocontrato", type="float", precision=10, scale=0, nullable=true)
     */
    private $saldocontrato;

    /**
     * @var string|null
     *
     * @ORM\Column(name="statuscontrato", type="string", length=255, nullable=true)
     */
    private $statuscontrato;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorparcela", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorparcela;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="vigenciadatafinal", type="datetime", nullable=true)
     */
    private $vigenciadatafinal;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="vigenciadatainicial", type="datetime", nullable=true)
     */
    private $vigenciadatainicial;

    /**
     * @var float|null
     *
     * @ORM\Column(name="vlrcontrato", type="float", precision=10, scale=0, nullable=true)
     */
    private $vlrcontrato;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datacancelamento", type="date", nullable=true)
     */
    private $datacancelamento;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datadistrato", type="date", nullable=true)
     */
    private $datadistrato;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nomecliente", type="string", length=255, nullable=true)
     */
    private $nomecliente;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="vigenciafinalatual", type="datetime", nullable=true)
     */
    private $vigenciafinalatual;

    /**
     * @var \Agrega.tbProposta
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProposta")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="proposta_id", referencedColumnName="id")
     * })
     */
    private $proposta;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
