<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbCoordenada
 *
 * @ORM\Table(name="agrega.tb_coordenada", indexes={@ORM\Index(name="IDX_E35AE7068A623FAB", columns={"alteradopor_id"}), @ORM\Index(name="IDX_E35AE706844156D0", columns={"cadastradopor_id"})})
 * @ORM\Entity
 */
class tbCoordenada
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_coordenada_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var int|null
     *
     * @ORM\Column(name="coordenadax", type="bigint", nullable=true)
     */
    private $coordenadax;

    /**
     * @var int|null
     *
     * @ORM\Column(name="coordenaday", type="bigint", nullable=true)
     */
    private $coordenaday;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datacadastro", type="date", nullable=true)
     */
    private $datacadastro;

    /**
     * @var int|null
     *
     * @ORM\Column(name="nrfoto", type="bigint", nullable=true)
     */
    private $nrfoto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obscoordenada", type="string", length=255, nullable=true)
     */
    private $obscoordenada;

    /**
     * @var int|null
     *
     * @ORM\Column(name="ordem", type="bigint", nullable=true)
     */
    private $ordem;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ponto", type="string", length=255, nullable=true)
     */
    private $ponto;

    /**
     * @var int|null
     *
     * @ORM\Column(name="projeto", type="bigint", nullable=true)
     */
    private $projeto;

    /**
     * @var int|null
     *
     * @ORM\Column(name="fuso", type="bigint", nullable=true)
     */
    private $fuso;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataalteracao", type="date", nullable=true)
     */
    private $dataalteracao;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="alteradopor_id", referencedColumnName="id")
     * })
     */
    private $alteradopor;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cadastradopor_id", referencedColumnName="id")
     * })
     */
    private $cadastradopor;


}
