<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbCustoDeslocamento
 *
 * @ORM\Table(name="agrega.tb_custo_deslocamento", indexes={@ORM\Index(name="IDX_34145BE435492110", columns={"usuarioatualizacao_id"}), @ORM\Index(name="IDX_34145BE4AE13E077", columns={"proposta_id"})})
 * @ORM\Entity
 */
class tbCustoDeslocamento
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_custo_deslocamento_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=255, nullable=true)
     */
    private $descricao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacoes", type="string", length=255, nullable=true)
     */
    private $observacoes;

    /**
     * @var int|null
     *
     * @ORM\Column(name="quantidade", type="bigint", nullable=true)
     */
    private $quantidade;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tpunidademedida", type="string", length=255, nullable=true)
     */
    private $tpunidademedida;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valortotal", type="float", precision=10, scale=0, nullable=true)
     */
    private $valortotal;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorunitario", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorunitario;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;

    /**
     * @var \Agrega.tbProposta
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProposta")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="proposta_id", referencedColumnName="id")
     * })
     */
    private $proposta;


}
