<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbCustoPlaninhaFinanceira
 *
 * @ORM\Table(name="agrega.tb_custo_planinha_financeira", indexes={@ORM\Index(name="IDX_524075F0AE13E077", columns={"proposta_id"})})
 * @ORM\Entity
 */
class tbCustoPlaninhaFinanceira
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_custo_planinha_financeira_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=255, nullable=true)
     */
    private $descricao;

    /**
     * @var int|null
     *
     * @ORM\Column(name="quantidade", type="bigint", nullable=true)
     */
    private $quantidade;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valortotal", type="float", precision=10, scale=0, nullable=true)
     */
    private $valortotal;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorunitario", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorunitario;

    /**
     * @var float|null
     *
     * @ORM\Column(name="desconto", type="float", precision=10, scale=0, nullable=true)
     */
    private $desconto;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valornegociado", type="float", precision=10, scale=0, nullable=true)
     */
    private $valornegociado;

    /**
     * @var \Agrega.tbProposta
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProposta")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="proposta_id", referencedColumnName="id")
     * })
     */
    private $proposta;


}
