<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbCustoPlaninhaTecnica
 *
 * @ORM\Table(name="agrega.tb_custo_planinha_tecnica", indexes={@ORM\Index(name="IDX_B8855A38AE13E077", columns={"proposta_id"})})
 * @ORM\Entity
 */
class tbCustoPlaninhaTecnica
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_custo_planinha_tecnica_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=255, nullable=true)
     */
    private $descricao;

    /**
     * @var int|null
     *
     * @ORM\Column(name="quantitativo", type="bigint", nullable=true)
     */
    private $quantitativo;

    /**
     * @var int|null
     *
     * @ORM\Column(name="unidade", type="integer", nullable=true)
     */
    private $unidade;

    /**
     * @var \Agrega.tbProposta
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProposta")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="proposta_id", referencedColumnName="id")
     * })
     */
    private $proposta;


}
