<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbDadosBancarios
 *
 * @ORM\Table(name="agrega.tb_dados_bancarios", indexes={@ORM\Index(name="IDX_CDCD261D995BA0E1", columns={"id_banco"})})
 * @ORM\Entity
 */
class tbDadosBancarios
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_dados_bancarios_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nr_agengia", type="string", length=255, nullable=true)
     */
    private $nrAgengia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nr_conta", type="string", length=255, nullable=true)
     */
    private $nrConta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tp_conta", type="string", length=255, nullable=true)
     */
    private $tpConta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nr_operacao", type="string", length=255, nullable=true)
     */
    private $nrOperacao;

    /**
     * @var \Agrega.tbBanco
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbBanco")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_banco", referencedColumnName="id")
     * })
     */
    private $idBanco;


}
