<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbDistancia
 *
 * @ORM\Table(name="agrega.tb_distancia", indexes={@ORM\Index(name="IDX_4D25F08343B58490", columns={"projeto_id"})})
 * @ORM\Entity
 */
class tbDistancia
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_distancia_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var float|null
     *
     * @ORM\Column(name="dis_distancia", type="float", precision=10, scale=0, nullable=true)
     */
    private $disDistancia;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="dis_pavimentada", type="boolean", nullable=true)
     */
    private $disPavimentada;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tpunidademedida", type="string", length=255, nullable=true)
     */
    private $tpunidademedida;

    /**
     * @var \Agrega.tbProjeto
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProjeto")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="projeto_id", referencedColumnName="id")
     * })
     */
    private $projeto;


}
