<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbEndereco
 *
 * @ORM\Table(name="agrega.tb_endereco", indexes={@ORM\Index(name="IDX_753FAB83773DA226", columns={"id_uf"}), @ORM\Index(name="IDX_753FAB834CAF86B1", columns={"id_cidade"})})
 * @ORM\Entity
 */
class tbEndereco
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_endereco_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ds_bairro", type="string", length=255, nullable=true)
     */
    private $dsBairro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nr_cep", type="string", length=255, nullable=true)
     */
    private $nrCep;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ds_complemento", type="string", length=255, nullable=true)
     */
    private $dsComplemento;

    /**
     * @var int|null
     *
     * @ORM\Column(name="nr_rua", type="bigint", nullable=true)
     */
    private $nrRua;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ds_rua", type="string", length=255, nullable=true)
     */
    private $dsRua;

    /**
     * @var \Agrega.tbUf
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUf")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_uf", referencedColumnName="id")
     * })
     */
    private $idUf;

    /**
     * @var \Agrega.tbCidade
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbCidade")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_cidade", referencedColumnName="id")
     * })
     */
    private $idCidade;


}
