<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbFaturamento
 *
 * @ORM\Table(name="agrega.tb_faturamento", indexes={@ORM\Index(name="IDX_C03E4075BB9AF004", columns={"responsavel_id"}), @ORM\Index(name="IDX_C03E407570AE7BF1", columns={"contrato_id"}), @ORM\Index(name="IDX_C03E407595FC38A6", columns={"situacao_id"})})
 * @ORM\Entity
 */
class tbFaturamento
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_faturamento_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datanf", type="datetime", nullable=true)
     */
    private $datanf;

    /**
     * @var int|null
     *
     * @ORM\Column(name="numeronf", type="bigint", nullable=true)
     */
    private $numeronf;

    /**
     * @var int|null
     *
     * @ORM\Column(name="parcela", type="bigint", nullable=true)
     */
    private $parcela;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorparcela", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorparcela;

    /**
     * @var int|null
     *
     * @ORM\Column(name="projeto_id", type="bigint", nullable=true)
     */
    private $projetoId;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="responsavel_id", referencedColumnName="id")
     * })
     */
    private $responsavel;

    /**
     * @var \Agrega.tbContrato
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbContrato")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="contrato_id", referencedColumnName="id")
     * })
     */
    private $contrato;

    /**
     * @var \Agrega.tbSituacao
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbSituacao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="situacao_id", referencedColumnName="id")
     * })
     */
    private $situacao;


}
