<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbFornecedor
 *
 * @ORM\Table(name="agrega.tb_fornecedor", indexes={@ORM\Index(name="IDX_B02F05F81BB76823", columns={"endereco_id"}), @ORM\Index(name="IDX_B02F05F870D4B648", columns={"dadosbancarios3_id"}), @ORM\Index(name="IDX_B02F05F835492110", columns={"usuarioatualizacao_id"}), @ORM\Index(name="IDX_B02F05F8C868D12D", columns={"dadosbancarios2_id"}), @ORM\Index(name="IDX_B02F05F874868CB", columns={"dadosbancarios_id"})})
 * @ORM\Entity
 */
class tbFornecedor
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_fornecedor_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="celular", type="string", length=255, nullable=true)
     */
    private $celular;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cnpjcpf", type="string", length=255, nullable=true)
     */
    private $cnpjcpf;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datacadastro", type="date", nullable=true)
     */
    private $datacadastro;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="email", type="string", length=255, nullable=true)
     */
    private $email;

    /**
     * @var string|null
     *
     * @ORM\Column(name="iscricaoestadual", type="string", length=255, nullable=true)
     */
    private $iscricaoestadual;

    /**
     * @var string|null
     *
     * @ORM\Column(name="iscricaomunicipal", type="string", length=255, nullable=true)
     */
    private $iscricaomunicipal;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nomefantasia", type="string", length=255, nullable=true)
     */
    private $nomefantasia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacao", type="string", length=501, nullable=true)
     */
    private $observacao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pessoacontato", type="string", length=255, nullable=true)
     */
    private $pessoacontato;

    /**
     * @var string|null
     *
     * @ORM\Column(name="principalatividade", type="string", length=255, nullable=true)
     */
    private $principalatividade;

    /**
     * @var string|null
     *
     * @ORM\Column(name="ramoatividade", type="string", length=255, nullable=true)
     */
    private $ramoatividade;

    /**
     * @var string|null
     *
     * @ORM\Column(name="razaosocial", type="string", length=255, nullable=true)
     */
    private $razaosocial;

    /**
     * @var string|null
     *
     * @ORM\Column(name="telefone", type="string", length=255, nullable=true)
     */
    private $telefone;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tipofornecedor", type="string", length=255, nullable=true)
     */
    private $tipofornecedor;

    /**
     * @var string|null
     *
     * @ORM\Column(name="celular2", type="string", length=255, nullable=true)
     */
    private $celular2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="usuarioinclusao", type="blob", nullable=true)
     */
    private $usuarioinclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="chavepix", type="string", length=255, nullable=true)
     */
    private $chavepix;

    /**
     * @var \Agrega.tbEndereco
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbEndereco")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="endereco_id", referencedColumnName="id")
     * })
     */
    private $endereco;

    /**
     * @var \Agrega.tbDadosBancarios
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbDadosBancarios")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dadosbancarios3_id", referencedColumnName="id")
     * })
     */
    private $dadosbancarios3;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;

    /**
     * @var \Agrega.tbDadosBancarios
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbDadosBancarios")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dadosbancarios2_id", referencedColumnName="id")
     * })
     */
    private $dadosbancarios2;

    /**
     * @var \Agrega.tbDadosBancarios
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbDadosBancarios")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dadosbancarios_id", referencedColumnName="id")
     * })
     */
    private $dadosbancarios;


}
