<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbMacroRegiao
 *
 * @ORM\Table(name="agrega.tb_macro_regiao", indexes={@ORM\Index(name="IDX_E536637D773DA226", columns={"id_uf"}), @ORM\Index(name="IDX_E536637D4CAF86B1", columns={"id_cidade"})})
 * @ORM\Entity
 */
class tbMacroRegiao
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_macro_regiao_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome_macro_regiao", type="string", length=255, nullable=true)
     */
    private $nomeMacroRegiao;

    /**
     * @var \Agrega.tbUf
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUf")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_uf", referencedColumnName="id")
     * })
     */
    private $idUf;

    /**
     * @var \Agrega.tbCidade
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbCidade")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_cidade", referencedColumnName="id")
     * })
     */
    private $idCidade;


}
