<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbMensagem
 *
 * @ORM\Table(name="agrega.tb_mensagem", indexes={@ORM\Index(name="IDX_139A4F3D7ADE2C4", columns={"profissional_id"})})
 * @ORM\Entity
 */
class tbMensagem
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_mensagem_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var int|null
     *
     * @ORM\Column(name="contador", type="bigint", nullable=true)
     */
    private $contador;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataalteracao", type="date", nullable=true)
     */
    private $dataalteracao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=501, nullable=true)
     */
    private $descricao;

    /**
     * @var bool
     *
     * @ORM\Column(name="lida", type="boolean", nullable=false)
     */
    private $lida;

    /**
     * @var int|null
     *
     * @ORM\Column(name="tipo", type="bigint", nullable=true)
     */
    private $tipo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="titulo", type="string", length=255, nullable=true)
     */
    private $titulo;

    /**
     * @var int|null
     *
     * @ORM\Column(name="projeto_id", type="bigint", nullable=true)
     */
    private $projetoId;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissional_id", referencedColumnName="id")
     * })
     */
    private $profissional;


}
