<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbMunicipio
 *
 * @ORM\Table(name="agrega.tb_municipio", indexes={@ORM\Index(name="IDX_6D1CD5009FAAD851", columns={"regiao_id"}), @ORM\Index(name="IDX_6D1CD500773DA226", columns={"id_uf"})})
 * @ORM\Entity
 */
class tbMunicipio
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_municipio_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome", type="string", length=255, nullable=true)
     */
    private $nome;

    /**
     * @var \Agrega.tbRegiao
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbRegiao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="regiao_id", referencedColumnName="id")
     * })
     */
    private $regiao;

    /**
     * @var \Agrega.tbUf
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUf")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_uf", referencedColumnName="id")
     * })
     */
    private $idUf;


}
