<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbNotificacao
 *
 * @ORM\Table(name="agrega.tb_notificacao", indexes={@ORM\Index(name="IDX_3FDDD32639C50FAE", columns={"registro_id"}), @ORM\Index(name="IDX_3FDDD32643B58490", columns={"projeto_id"})})
 * @ORM\Entity
 */
class tbNotificacao
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_notificacao_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datarecebimento", type="datetime", nullable=true)
     */
    private $datarecebimento;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataresposta", type="datetime", nullable=true)
     */
    private $dataresposta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="motivo", type="string", length=255, nullable=true)
     */
    private $motivo;

    /**
     * @var int|null
     *
     * @ORM\Column(name="numero", type="bigint", nullable=true)
     */
    private $numero;

    /**
     * @var string|null
     *
     * @ORM\Column(name="responsavelresposta", type="string", length=255, nullable=true)
     */
    private $responsavelresposta;

    /**
     * @var \Agrega.tbRegistro
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbRegistro")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="registro_id", referencedColumnName="id")
     * })
     */
    private $registro;

    /**
     * @var \Agrega.tbProjeto
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProjeto")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="projeto_id", referencedColumnName="id")
     * })
     */
    private $projeto;


}
