<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbOrdemServico
 *
 * @ORM\Table(name="agrega.tb_ordem_servico", indexes={@ORM\Index(name="IDX_5C90CF4EDE734E51", columns={"cliente_id"}), @ORM\Index(name="IDX_5C90CF4E70AE7BF1", columns={"contrato_id"}), @ORM\Index(name="IDX_5C90CF4E35492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbOrdemServico
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_ordem_servico_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datacriacao", type="datetime", nullable=true)
     */
    private $datacriacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datafinalizacao", type="datetime", nullable=true)
     */
    private $datafinalizacao;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var int|null
     *
     * @ORM\Column(name="contadornros", type="bigint", nullable=true)
     */
    private $contadornros;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataexclusao", type="date", nullable=true)
     */
    private $dataexclusao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numeroos", type="string", length=255, nullable=true)
     */
    private $numeroos;

    /**
     * @var int|null
     *
     * @ORM\Column(name="qtdcadastrada", type="integer", nullable=true)
     */
    private $qtdcadastrada;

    /**
     * @var int|null
     *
     * @ORM\Column(name="qtdfaturada", type="integer", nullable=true)
     */
    private $qtdfaturada;

    /**
     * @var int|null
     *
     * @ORM\Column(name="qtdprojetos", type="integer", nullable=true)
     */
    private $qtdprojetos;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorfaturado", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorfaturado;

    /**
     * @var \Agrega.tbCliente
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbCliente")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cliente_id", referencedColumnName="id")
     * })
     */
    private $cliente;

    /**
     * @var \Agrega.tbContrato
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbContrato")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="contrato_id", referencedColumnName="id")
     * })
     */
    private $contrato;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
