<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbParcela
 *
 * @ORM\Table(name="agrega.tb_parcela", indexes={@ORM\Index(name="IDX_72BC3C59223A2D8A", columns={"itenid"}), @ORM\Index(name="IDX_72BC3C593C48E38F", columns={"contratoid"})})
 * @ORM\Entity
 */
class tbParcela
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_parcela_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datavencimento", type="date", nullable=true)
     */
    private $datavencimento;

    /**
     * @var int|null
     *
     * @ORM\Column(name="nrparcela", type="integer", nullable=true)
     */
    private $nrparcela;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacoesparcela", type="string", length=255, nullable=true)
     */
    private $observacoesparcela;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorparcela", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorparcela;

    /**
     * @var \Agrega.tbItensContrato
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbItensContrato")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="itenid", referencedColumnName="id")
     * })
     */
    private $itenid;

    /**
     * @var \Agrega.tbContrato
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbContrato")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="contratoid", referencedColumnName="id")
     * })
     */
    private $contratoid;


}
