<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbParcelaProjeto
 *
 * @ORM\Table(name="agrega.tb_parcela_projeto", indexes={@ORM\Index(name="IDX_1FAD3B837EC834E4", columns={"id_projeto"})})
 * @ORM\Entity
 */
class tbParcelaProjeto
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_parcela_projeto_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datacobranca", type="datetime", nullable=true)
     */
    private $datacobranca;

    /**
     * @var int|null
     *
     * @ORM\Column(name="notafiscal", type="bigint", nullable=true)
     */
    private $notafiscal;

    /**
     * @var int|null
     *
     * @ORM\Column(name="numeroparcela", type="bigint", nullable=true)
     */
    private $numeroparcela;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacao", type="string", length=255, nullable=true)
     */
    private $observacao;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorparcela", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorparcela;

    /**
     * @var \Agrega.tbProjeto
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProjeto")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_projeto", referencedColumnName="id")
     * })
     */
    private $idProjeto;


}
