<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbPerfil
 *
 * @ORM\Table(name="agrega.tb_perfil", indexes={@ORM\Index(name="IDX_EBCF87A635492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbPerfil
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_perfil_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome", type="string", length=255, nullable=true)
     */
    private $nome;

    /**
     * @var string|null
     *
     * @ORM\Column(name="sigla", type="string", length=255, nullable=true)
     */
    private $sigla;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
