<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbPlanTecEquipamento
 *
 * @ORM\Table(name="agrega.tb_plan_tec_equipamento", indexes={@ORM\Index(name="IDX_67FA2C07AE13E077", columns={"proposta_id"})})
 * @ORM\Entity
 */
class tbPlanTecEquipamento
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_plan_tec_equipamento_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=255, nullable=true)
     */
    private $descricao;

    /**
     * @var int|null
     *
     * @ORM\Column(name="equipeadm", type="integer", nullable=true)
     */
    private $equipeadm;

    /**
     * @var int|null
     *
     * @ORM\Column(name="equipecampo", type="integer", nullable=true)
     */
    private $equipecampo;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="item", type="boolean", nullable=true)
     */
    private $item;

    /**
     * @var \Agrega.tbProposta
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProposta")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="proposta_id", referencedColumnName="id")
     * })
     */
    private $proposta;


}
