<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbPlanejamento
 *
 * @ORM\Table(name="agrega.tb_planejamento", indexes={@ORM\Index(name="IDX_B44E36E3EB3BC75", columns={"profissionalepi_id"}), @ORM\Index(name="IDX_B44E36E310B87F06", columns={"profissionalmapas_id"}), @ORM\Index(name="IDX_B44E36E343B58490", columns={"projeto_id"}), @ORM\Index(name="IDX_B44E36E3ACCBEA07", columns={"profissionalevctgal_id"}), @ORM\Index(name="IDX_B44E36E3E811FA8D", columns={"profissionalverificacao_id"})})
 * @ORM\Entity
 */
class tbPlanejamento
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_planejamento_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainsercao", type="date", nullable=true)
     */
    private $datainsercao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtentrega", type="datetime", nullable=true)
     */
    private $dtentrega;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtinicioplanejamento", type="datetime", nullable=true)
     */
    private $dtinicioplanejamento;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtfimplanejamento", type="datetime", nullable=true)
     */
    private $dtfimplanejamento;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obsplanejamento", type="string", length=1001, nullable=true)
     */
    private $obsplanejamento;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalepi_id", referencedColumnName="id")
     * })
     */
    private $profissionalepi;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalmapas_id", referencedColumnName="id")
     * })
     */
    private $profissionalmapas;

    /**
     * @var \Agrega.tbProjeto
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProjeto")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="projeto_id", referencedColumnName="id")
     * })
     */
    private $projeto;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalevctgal_id", referencedColumnName="id")
     * })
     */
    private $profissionalevctgal;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalverificacao_id", referencedColumnName="id")
     * })
     */
    private $profissionalverificacao;


}
