<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbPlanejamentos
 *
 * @ORM\Table(name="agrega.tb_planejamentos", indexes={@ORM\Index(name="IDX_22B932FF35492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbPlanejamentos
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_planejamentos_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtalteracaoplanej", type="date", nullable=true)
     */
    private $dtalteracaoplanej;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtcriacaoplanej", type="date", nullable=true)
     */
    private $dtcriacaoplanej;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome", type="string", length=255, nullable=true)
     */
    private $nome;

    /**
     * @var int|null
     *
     * @ORM\Column(name="nrplan", type="integer", nullable=true)
     */
    private $nrplan;

    /**
     * @var int|null
     *
     * @ORM\Column(name="nrrevisao", type="integer", nullable=true)
     */
    private $nrrevisao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="titulo", type="string", length=255, nullable=true)
     */
    private $titulo;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
