<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbProfissional
 *
 * @ORM\Table(name="agrega.tb_profissional", uniqueConstraints={@ORM\UniqueConstraint(name="uk_rud84yneqenio0rta6e8v19nv", columns={"enderecopj_id"})}, indexes={@ORM\Index(name="IDX_32A9D54D74868CB", columns={"dadosbancarios_id"}), @ORM\Index(name="IDX_32A9D54D257BECAD", columns={"usuarioacesso_id"}), @ORM\Index(name="IDX_32A9D54DB9A26D71", columns={"contabancaria3_id"}), @ORM\Index(name="IDX_32A9D54DD3EBB69D", columns={"fornecedor_id"}), @ORM\Index(name="IDX_32A9D54D11E0A14", columns={"contabancaria2_id"}), @ORM\Index(name="IDX_32A9D54D1BB76823", columns={"endereco_id"}), @ORM\Index(name="IDX_32A9D54D35492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbProfissional
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_profissional_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="asovalidade", type="datetime", nullable=true)
     */
    private $asovalidade;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="celular", type="string", length=255, nullable=true)
     */
    private $celular;

    /**
     * @var string|null
     *
     * @ORM\Column(name="classectps", type="string", length=255, nullable=true)
     */
    private $classectps;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cnae", type="string", length=255, nullable=true)
     */
    private $cnae;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cnh", type="string", length=255, nullable=true)
     */
    private $cnh;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cnpj", type="string", length=255, nullable=true)
     */
    private $cnpj;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cpf", type="string", length=255, nullable=true)
     */
    private $cpf;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datanascimento", type="date", nullable=true)
     */
    private $datanascimento;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaodiversa", type="string", length=501, nullable=true)
     */
    private $descricaodiversa;

    /**
     * @var string|null
     *
     * @ORM\Column(name="disponibilidade", type="string", length=255, nullable=true)
     */
    private $disponibilidade;

    /**
     * @var string|null
     *
     * @ORM\Column(name="email", type="string", length=255, nullable=true)
     */
    private $email;

    /**
     * @var string|null
     *
     * @ORM\Column(name="emailpj", type="string", length=255, nullable=true)
     */
    private $emailpj;

    /**
     * @var string|null
     *
     * @ORM\Column(name="escolaridade", type="string", length=255, nullable=true)
     */
    private $escolaridade;

    /**
     * @var string|null
     *
     * @ORM\Column(name="especializacao", type="string", length=255, nullable=true)
     */
    private $especializacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fimatividade", type="date", nullable=true)
     */
    private $fimatividade;

    /**
     * @var string|null
     *
     * @ORM\Column(name="funcaocargo", type="string", length=255, nullable=true)
     */
    private $funcaocargo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="graduacao", type="string", length=255, nullable=true)
     */
    private $graduacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="inicioatividade", type="date", nullable=true)
     */
    private $inicioatividade;

    /**
     * @var int|null
     *
     * @ORM\Column(name="inscricaoestadual", type="bigint", nullable=true)
     */
    private $inscricaoestadual;

    /**
     * @var int|null
     *
     * @ORM\Column(name="inscricaomunicipal", type="bigint", nullable=true)
     */
    private $inscricaomunicipal;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome", type="string", length=255, nullable=true)
     */
    private $nome;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numeroctps", type="string", length=255, nullable=true)
     */
    private $numeroctps;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numerosapato", type="string", length=255, nullable=true)
     */
    private $numerosapato;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pispasep", type="string", length=255, nullable=true)
     */
    private $pispasep;

    /**
     * @var string|null
     *
     * @ORM\Column(name="posgraducao", type="string", length=255, nullable=true)
     */
    private $posgraducao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="profissao", type="string", length=255, nullable=true)
     */
    private $profissao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="razaosocial", type="string", length=255, nullable=true)
     */
    private $razaosocial;

    /**
     * @var string|null
     *
     * @ORM\Column(name="rg", type="string", length=255, nullable=true)
     */
    private $rg;

    /**
     * @var string|null
     *
     * @ORM\Column(name="seriectps", type="string", length=255, nullable=true)
     */
    private $seriectps;

    /**
     * @var string|null
     *
     * @ORM\Column(name="sigla", type="string", length=255, nullable=true)
     */
    private $sigla;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tamanhocalca", type="string", length=255, nullable=true)
     */
    private $tamanhocalca;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tamanhocamisa", type="string", length=255, nullable=true)
     */
    private $tamanhocamisa;

    /**
     * @var string|null
     *
     * @ORM\Column(name="telefone", type="string", length=255, nullable=true)
     */
    private $telefone;

    /**
     * @var string|null
     *
     * @ORM\Column(name="telefoneprincipal", type="string", length=255, nullable=true)
     */
    private $telefoneprincipal;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tipocolaborador", type="string", length=255, nullable=true)
     */
    private $tipocolaborador;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tipocontratacao", type="string", length=255, nullable=true)
     */
    private $tipocontratacao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tiposanguineo", type="string", length=255, nullable=true)
     */
    private $tiposanguineo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numeroconselho", type="string", length=255, nullable=true)
     */
    private $numeroconselho;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="acessarintegra", type="boolean", nullable=true)
     */
    private $acessarintegra;

    /**
     * @var string|null
     *
     * @ORM\Column(name="celular2", type="string", length=255, nullable=true)
     */
    private $celular2;

    /**
     * @var string|null
     *
     * @ORM\Column(name="chavepix", type="string", length=255, nullable=true)
     */
    private $chavepix;

    /**
     * @var \Agrega.tbDadosBancarios
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbDadosBancarios")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dadosbancarios_id", referencedColumnName="id")
     * })
     */
    private $dadosbancarios;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioacesso_id", referencedColumnName="id")
     * })
     */
    private $usuarioacesso;

    /**
     * @var \Agrega.tbDadosBancarios
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbDadosBancarios")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="contabancaria3_id", referencedColumnName="id")
     * })
     */
    private $contabancaria3;

    /**
     * @var \Agrega.tbFornecedor
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbFornecedor")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="fornecedor_id", referencedColumnName="id")
     * })
     */
    private $fornecedor;

    /**
     * @var \Agrega.tbDadosBancarios
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbDadosBancarios")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="contabancaria2_id", referencedColumnName="id")
     * })
     */
    private $contabancaria2;

    /**
     * @var \Agrega.tbEndereco
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbEndereco")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="enderecopj_id", referencedColumnName="id")
     * })
     */
    private $enderecopj;

    /**
     * @var \Agrega.tbEndereco
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbEndereco")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="endereco_id", referencedColumnName="id")
     * })
     */
    private $endereco;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
