<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbProjeto
 *
 * @ORM\Table(name="agrega.tb_projeto", indexes={@ORM\Index(name="IDX_7725E58BBDF97E43", columns={"caracteristicasprojeto_id"}), @ORM\Index(name="IDX_7725E58B35492110", columns={"usuarioatualizacao_id"}), @ORM\Index(name="IDX_7725E58B1070FD24", columns={"profverif_id"}), @ORM\Index(name="IDX_7725E58B4EF4A36A", columns={"ordemservico_id"}), @ORM\Index(name="IDX_7725E58B54FE17F8", columns={"profepi_id"}), @ORM\Index(name="IDX_7725E58BF478178", columns={"tipoprograma_id"}), @ORM\Index(name="IDX_7725E58B688B559F", columns={"planejamentos_id"}), @ORM\Index(name="IDX_7725E58BA8BCBFC2", columns={"profevctgal_id"}), @ORM\Index(name="IDX_7725E58BDE734E51", columns={"cliente_id"}), @ORM\Index(name="IDX_7725E58BAC579461", columns={"estadodadostecnico_id"}), @ORM\Index(name="IDX_7725E58B95FC38A6", columns={"situacao_id"}), @ORM\Index(name="IDX_7725E58B58BC1BE0", columns={"municipio_id"}), @ORM\Index(name="IDX_7725E58B6039B058", columns={"profissionalgestor_id"}), @ORM\Index(name="IDX_7725E58B70AE7BF1", columns={"contrato_id"}), @ORM\Index(name="IDX_7725E58B6BF700BD", columns={"status_id"}), @ORM\Index(name="IDX_7725E58BDF91B92D", columns={"profmapas_id"})})
 * @ORM\Entity
 */
class tbProjeto
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_projeto_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var float|null
     *
     * @ORM\Column(name="areaha", type="float", precision=10, scale=0, nullable=true)
     */
    private $areaha;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=true)
     */
    private $ativo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="cabos", type="string", length=255, nullable=true)
     */
    private $cabos;

    /**
     * @var float|null
     *
     * @ORM\Column(name="conjugadakm", type="float", precision=10, scale=0, nullable=true)
     */
    private $conjugadakm;

    /**
     * @var int|null
     *
     * @ORM\Column(name="consumidores", type="bigint", nullable=true)
     */
    private $consumidores;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataentrada", type="datetime", nullable=true)
     */
    private $dataentrada;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var float|null
     *
     * @ORM\Column(name="distanciamunlocalprojnaopav", type="float", precision=10, scale=0, nullable=true)
     */
    private $distanciamunlocalprojnaopav;

    /**
     * @var float|null
     *
     * @ORM\Column(name="distanciamunlocalprojpav", type="float", precision=10, scale=0, nullable=true)
     */
    private $distanciamunlocalprojpav;

    /**
     * @var float|null
     *
     * @ORM\Column(name="distanciasedemunnaopav", type="float", precision=10, scale=0, nullable=true)
     */
    private $distanciasedemunnaopav;

    /**
     * @var float|null
     *
     * @ORM\Column(name="distanciasedemunpav", type="float", precision=10, scale=0, nullable=true)
     */
    private $distanciasedemunpav;

    /**
     * @var string|null
     *
     * @ORM\Column(name="empresaprojetoeletrico", type="string", length=255, nullable=true)
     */
    private $empresaprojetoeletrico;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="ep", type="boolean", nullable=true)
     */
    private $ep;

    /**
     * @var float|null
     *
     * @ORM\Column(name="extensaototalkm", type="float", precision=10, scale=0, nullable=true)
     */
    private $extensaototalkm;

    /**
     * @var string|null
     *
     * @ORM\Column(name="faixaservidaom", type="string", length=255, nullable=true)
     */
    private $faixaservidaom;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="meiofisico", type="boolean", nullable=true)
     */
    private $meiofisico;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="meiosocioeconomico", type="boolean", nullable=true)
     */
    private $meiosocioeconomico;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nomeprojeto", type="string", length=255, nullable=true)
     */
    private $nomeprojeto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numeroart", type="string", length=255, nullable=true)
     */
    private $numeroart;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numeroprojetoagrega", type="string", length=255, nullable=true)
     */
    private $numeroprojetoagrega;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numeroprojetocliente", type="string", length=255, nullable=true)
     */
    private $numeroprojetocliente;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obscaracteristicas", type="string", length=255, nullable=true)
     */
    private $obscaracteristicas;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obsdadoscampo", type="string", length=1001, nullable=true)
     */
    private $obsdadoscampo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obsdadostecnico", type="string", length=1001, nullable=true)
     */
    private $obsdadostecnico;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obsverificacao", type="string", length=255, nullable=true)
     */
    private $obsverificacao;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="possuilpt", type="boolean", nullable=true)
     */
    private $possuilpt;

    /**
     * @var int|null
     *
     * @ORM\Column(name="postesprimario", type="bigint", nullable=true)
     */
    private $postesprimario;

    /**
     * @var int|null
     *
     * @ORM\Column(name="postessecundario", type="bigint", nullable=true)
     */
    private $postessecundario;

    /**
     * @var int|null
     *
     * @ORM\Column(name="postestotal", type="bigint", nullable=true)
     */
    private $postestotal;

    /**
     * @var float|null
     *
     * @ORM\Column(name="primariakm", type="float", precision=10, scale=0, nullable=true)
     */
    private $primariakm;

    /**
     * @var float|null
     *
     * @ORM\Column(name="saldorestante", type="float", precision=10, scale=0, nullable=true)
     */
    private $saldorestante;

    /**
     * @var float|null
     *
     * @ORM\Column(name="secundariakm", type="float", precision=10, scale=0, nullable=true)
     */
    private $secundariakm;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="sitioarquilogico", type="boolean", nullable=true)
     */
    private $sitioarquilogico;

    /**
     * @var string|null
     *
     * @ORM\Column(name="subtipoprojeto", type="string", length=255, nullable=true)
     */
    private $subtipoprojeto;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="supresaovegetacao", type="boolean", nullable=true)
     */
    private $supresaovegetacao;

    /**
     * @var float|null
     *
     * @ORM\Column(name="tamanhoprojeto", type="float", precision=10, scale=0, nullable=true)
     */
    private $tamanhoprojeto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="telresponsaveleletrico", type="string", length=255, nullable=true)
     */
    private $telresponsaveleletrico;

    /**
     * @var float|null
     *
     * @ORM\Column(name="tensaoprimariakv", type="float", precision=10, scale=0, nullable=true)
     */
    private $tensaoprimariakv;

    /**
     * @var float|null
     *
     * @ORM\Column(name="tensaosecundariakv", type="float", precision=10, scale=0, nullable=true)
     */
    private $tensaosecundariakv;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tipoprojeto", type="string", length=255, nullable=true)
     */
    private $tipoprojeto;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="unidadaconservacao", type="boolean", nullable=true)
     */
    private $unidadaconservacao;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorjacobrado", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorjacobrado;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valorprojeto", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorprojeto;

    /**
     * @var int|null
     *
     * @ORM\Column(name="profissional_id", type="bigint", nullable=true)
     */
    private $profissionalId;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtentrega", type="date", nullable=true)
     */
    private $dtentrega;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtfimplanj", type="date", nullable=true)
     */
    private $dtfimplanj;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtiniplanj", type="date", nullable=true)
     */
    private $dtiniplanj;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obsplanejamento", type="string", length=1001, nullable=true)
     */
    private $obsplanejamento;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="japlanejado", type="boolean", nullable=true)
     */
    private $japlanejado;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacoespagamento", type="string", length=1001, nullable=true)
     */
    private $observacoespagamento;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obsempresaexecutora", type="string", length=255, nullable=true)
     */
    private $obsempresaexecutora;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="verificanotificacao", type="boolean", nullable=true)
     */
    private $verificanotificacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datafinalcampo", type="date", nullable=true)
     */
    private $datafinalcampo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataincialcampo", type="date", nullable=true)
     */
    private $dataincialcampo;

    /**
     * @var int|null
     *
     * @ORM\Column(name="anoreferencia", type="bigint", nullable=true)
     */
    private $anoreferencia;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="checkepi", type="boolean", nullable=true)
     */
    private $checkepi;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="checkevctga", type="boolean", nullable=true)
     */
    private $checkevctga;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="checkmapa", type="boolean", nullable=true)
     */
    private $checkmapa;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="checkverificacap", type="boolean", nullable=true)
     */
    private $checkverificacap;

    /**
     * @var int|null
     *
     * @ORM\Column(name="situacaoplanejamento", type="bigint", nullable=true)
     */
    private $situacaoplanejamento;

    /**
     * @var int|null
     *
     * @ORM\Column(name="modalidade", type="bigint", nullable=true)
     */
    private $modalidade;

    /**
     * @var int|null
     *
     * @ORM\Column(name="idos", type="bigint", nullable=true)
     */
    private $idos;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtentregarealizada", type="date", nullable=true)
     */
    private $dtentregarealizada;

    /**
     * @var bool
     *
     * @ORM\Column(name="ausecoordenada", type="boolean", nullable=false)
     */
    private $ausecoordenada = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="autpassagem", type="boolean", nullable=false)
     */
    private $autpassagem = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="capa", type="boolean", nullable=false)
     */
    private $capa = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="cartaviapublica", type="boolean", nullable=false)
     */
    private $cartaviapublica = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="croki", type="boolean", nullable=false)
     */
    private $croki = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="folhaprojeletrico", type="boolean", nullable=false)
     */
    private $folhaprojeletrico = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="mapachave", type="boolean", nullable=false)
     */
    private $mapachave = false;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="meiobiotico", type="boolean", nullable=true)
     */
    private $meiobiotico = false;

    /**
     * @var bool
     *
     * @ORM\Column(name="sitprojeto", type="boolean", nullable=false)
     */
    private $sitprojeto = false;

    /**
     * @var string|null
     *
     * @ORM\Column(name="obsdadosfronteira", type="string", length=1000, nullable=true)
     */
    private $obsdadosfronteira;

    /**
     * @var \Agrega.tbCaracteristicasProjeto
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbCaracteristicasProjeto")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="caracteristicasprojeto_id", referencedColumnName="id")
     * })
     */
    private $caracteristicasprojeto;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profverif_id", referencedColumnName="id")
     * })
     */
    private $profverif;

    /**
     * @var \Agrega.tbOrdemServico
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbOrdemServico")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ordemservico_id", referencedColumnName="id")
     * })
     */
    private $ordemservico;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profepi_id", referencedColumnName="id")
     * })
     */
    private $profepi;

    /**
     * @var \Agrega.tbTipoPrograma
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbTipoPrograma")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tipoprograma_id", referencedColumnName="id")
     * })
     */
    private $tipoprograma;

    /**
     * @var \Agrega.tbPlanejamentos
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbPlanejamentos")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="planejamentos_id", referencedColumnName="id")
     * })
     */
    private $planejamentos;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profevctgal_id", referencedColumnName="id")
     * })
     */
    private $profevctgal;

    /**
     * @var \Agrega.tbCliente
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbCliente")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cliente_id", referencedColumnName="id")
     * })
     */
    private $cliente;

    /**
     * @var \Agrega.tbUf
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUf")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="estadodadostecnico_id", referencedColumnName="id")
     * })
     */
    private $estadodadostecnico;

    /**
     * @var \Agrega.tbSituacao
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbSituacao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="situacao_id", referencedColumnName="id")
     * })
     */
    private $situacao;

    /**
     * @var \Agrega.tbMunicipio
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbMunicipio")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="municipio_id", referencedColumnName="id")
     * })
     */
    private $municipio;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalgestor_id", referencedColumnName="id")
     * })
     */
    private $profissionalgestor;

    /**
     * @var \Agrega.tbContrato
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbContrato")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="contrato_id", referencedColumnName="id")
     * })
     */
    private $contrato;

    /**
     * @var \Agrega.tbStatus
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbStatus")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="status_id", referencedColumnName="id")
     * })
     */
    private $status;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profmapas_id", referencedColumnName="id")
     * })
     */
    private $profmapas;


}
