<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbProjetoOrdemServico
 *
 * @ORM\Table(name="agrega.tb_projeto_ordem_servico", indexes={@ORM\Index(name="IDX_36D64C44EF4A36A", columns={"ordemservico_id"}), @ORM\Index(name="IDX_36D64C435492110", columns={"usuarioatualizacao_id"}), @ORM\Index(name="IDX_36D64C443B58490", columns={"projeto_id"})})
 * @ORM\Entity
 */
class tbProjetoOrdemServico
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_projeto_ordem_servico_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=true)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var \Agrega.tbOrdemServico
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbOrdemServico")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ordemservico_id", referencedColumnName="id")
     * })
     */
    private $ordemservico;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;

    /**
     * @var \Agrega.tbProjeto
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProjeto")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="projeto_id", referencedColumnName="id")
     * })
     */
    private $projeto;


}
