<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbProposta
 *
 * @ORM\Table(name="agrega.tb_proposta", indexes={@ORM\Index(name="IDX_7B3E7356DE734E51", columns={"cliente_id"}), @ORM\Index(name="IDX_7B3E735635492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbProposta
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_proposta_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="assinaturafinanc", type="string", length=255, nullable=true)
     */
    private $assinaturafinanc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="assinaturatec", type="string", length=255, nullable=true)
     */
    private $assinaturatec;

    /**
     * @var string|null
     *
     * @ORM\Column(name="assinaturatecfinan", type="string", length=255, nullable=true)
     */
    private $assinaturatecfinan;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="coletapreco", type="string", length=255, nullable=true)
     */
    private $coletapreco;

    /**
     * @var string|null
     *
     * @ORM\Column(name="consideracoesfinais", type="string", length=255, nullable=true)
     */
    private $consideracoesfinais;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dadosdestenviotecfinan", type="string", length=255, nullable=true)
     */
    private $dadosdestenviotecfinan;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dadosdestinatarioenviofinanceiro", type="string", length=255, nullable=true)
     */
    private $dadosdestinatarioenviofinanceiro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dadosdestinatarioenviotecnico", type="string", length=255, nullable=true)
     */
    private $dadosdestinatarioenviotecnico;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataaprovacao", type="datetime", nullable=true)
     */
    private $dataaprovacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var float|null
     *
     * @ORM\Column(name="desconto", type="float", precision=10, scale=0, nullable=true)
     */
    private $desconto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaofinanceira", type="string", length=3500, nullable=true)
     */
    private $descricaofinanceira;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaotecfinan", type="string", length=3500, nullable=true)
     */
    private $descricaotecfinan;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaotecnica", type="string", length=3500, nullable=true)
     */
    private $descricaotecnica;

    /**
     * @var string|null
     *
     * @ORM\Column(name="destenviotecfinan", type="string", length=255, nullable=true)
     */
    private $destenviotecfinan;

    /**
     * @var string|null
     *
     * @ORM\Column(name="destinatarioenviofinanceiro", type="string", length=255, nullable=true)
     */
    private $destinatarioenviofinanceiro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="destinatarioenviotecnico", type="string", length=255, nullable=true)
     */
    private $destinatarioenviotecnico;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dptoenviofinanceiro", type="string", length=1000, nullable=true)
     */
    private $dptoenviofinanceiro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dptoenviotecfinan", type="string", length=1000, nullable=true)
     */
    private $dptoenviotecfinan;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dptoenviotecnico", type="string", length=1000, nullable=true)
     */
    private $dptoenviotecnico;

    /**
     * @var string|null
     *
     * @ORM\Column(name="dtlimiteapreset", type="string", length=255, nullable=true)
     */
    private $dtlimiteapreset;

    /**
     * @var string|null
     *
     * @ORM\Column(name="financeirocusto", type="string", length=255, nullable=true)
     */
    private $financeirocusto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="formapagtofinanc", type="string", length=255, nullable=true)
     */
    private $formapagtofinanc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="funcaocargofinanc", type="string", length=255, nullable=true)
     */
    private $funcaocargofinanc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="funcaocargotec", type="string", length=255, nullable=true)
     */
    private $funcaocargotec;

    /**
     * @var string|null
     *
     * @ORM\Column(name="funcaocargotecfinan", type="string", length=255, nullable=true)
     */
    private $funcaocargotecfinan;

    /**
     * @var int|null
     *
     * @ORM\Column(name="idarea", type="bigint", nullable=true)
     */
    private $idarea;

    /**
     * @var int|null
     *
     * @ORM\Column(name="idnegocio", type="bigint", nullable=true)
     */
    private $idnegocio;

    /**
     * @var int|null
     *
     * @ORM\Column(name="idserviconegocio", type="bigint", nullable=true)
     */
    private $idserviconegocio;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nomeprojeto", type="string", length=255, nullable=true)
     */
    private $nomeprojeto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nomeproposta", type="string", length=255, nullable=true)
     */
    private $nomeproposta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numeroproposta", type="string", length=255, nullable=true)
     */
    private $numeroproposta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numerorevisao", type="string", length=255, nullable=true)
     */
    private $numerorevisao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="objdadosempresa", type="string", length=255, nullable=true)
     */
    private $objdadosempresa;

    /**
     * @var string|null
     *
     * @ORM\Column(name="objprincfinc", type="string", length=255, nullable=true)
     */
    private $objprincfinc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="objprinctec", type="string", length=255, nullable=true)
     */
    private $objprinctec;

    /**
     * @var string|null
     *
     * @ORM\Column(name="objprinctecfinac", type="string", length=255, nullable=true)
     */
    private $objprinctecfinac;

    /**
     * @var float|null
     *
     * @ORM\Column(name="percentualbdi", type="float", precision=10, scale=0, nullable=true)
     */
    private $percentualbdi;

    /**
     * @var float|null
     *
     * @ORM\Column(name="percentualcomissao", type="float", precision=10, scale=0, nullable=true)
     */
    private $percentualcomissao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="respprojeto", type="string", length=255, nullable=true)
     */
    private $respprojeto;

    /**
     * @var int|null
     *
     * @ORM\Column(name="revisaoprecificacao", type="bigint", nullable=true)
     */
    private $revisaoprecificacao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="statusproposta", type="string", length=255, nullable=true)
     */
    private $statusproposta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="textpropostagenerica", type="string", length=255, nullable=true)
     */
    private $textpropostagenerica;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tipoproposta", type="string", length=255, nullable=true)
     */
    private $tipoproposta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="unidade", type="string", length=255, nullable=true)
     */
    private $unidade;

    /**
     * @var string|null
     *
     * @ORM\Column(name="validadefinc", type="string", length=255, nullable=true)
     */
    private $validadefinc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="validadetec", type="string", length=255, nullable=true)
     */
    private $validadetec;

    /**
     * @var string|null
     *
     * @ORM\Column(name="validadetecfinac", type="string", length=255, nullable=true)
     */
    private $validadetecfinac;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalcombdicomissao", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalcombdicomissao;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalcustoplanilhafinanceira", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalcustoplanilhafinanceira;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalcustosadministrativos", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalcustosadministrativos;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalcustosbdicomissoes", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalcustosbdicomissoes;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalcustosdesclocamento", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalcustosdesclocamento;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalcustosexecucao", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalcustosexecucao;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalcustosoperacionais", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalcustosoperacionais;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalcustosseguranca", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalcustosseguranca;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valortotaldaproposta", type="float", precision=10, scale=0, nullable=true)
     */
    private $valortotaldaproposta;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalimpostos", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalimpostos;

    /**
     * @var float
     *
     * @ORM\Column(name="valortotalprecificacao", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalprecificacao;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valortotalsembdicomissao", type="float", precision=10, scale=0, nullable=true)
     */
    private $valortotalsembdicomissao;

    /**
     * @var float|null
     *
     * @ORM\Column(name="descplanfin", type="float", precision=10, scale=0, nullable=true)
     */
    private $descplanfin;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaplancomer", type="string", length=255, nullable=true)
     */
    private $descricaplancomer;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaplantecnica", type="string", length=255, nullable=true)
     */
    private $descricaplantecnica;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaoplanilhafinac", type="string", length=255, nullable=true)
     */
    private $descricaoplanilhafinac;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="inserirplancom", type="boolean", nullable=true)
     */
    private $inserirplancom;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="inserirplanfinan", type="boolean", nullable=true)
     */
    private $inserirplanfinan;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="inserirplantec", type="boolean", nullable=true)
     */
    private $inserirplantec;

    /**
     * @var string|null
     *
     * @ORM\Column(name="titiloplanilhafinc", type="string", length=255, nullable=true)
     */
    private $titiloplanilhafinc;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tituloplancomer", type="string", length=255, nullable=true)
     */
    private $tituloplancomer;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tituloplantecnica", type="string", length=255, nullable=true)
     */
    private $tituloplantecnica;

    /**
     * @var float|null
     *
     * @ORM\Column(name="vlrnegtotalplanfinanceira", type="float", precision=10, scale=0, nullable=true)
     */
    private $vlrnegtotalplanfinanceira;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaplanequipamento", type="string", length=255, nullable=true)
     */
    private $descricaplanequipamento;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="inserirplantecequipamento", type="boolean", nullable=true)
     */
    private $inserirplantecequipamento;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tituloplanequipamento", type="string", length=255, nullable=true)
     */
    private $tituloplanequipamento;

    /**
     * @var int|null
     *
     * @ORM\Column(name="ordproposta", type="integer", nullable=true)
     */
    private $ordproposta;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtemisspropfinc", type="date", nullable=true)
     */
    private $dtemisspropfinc;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtemissproptec", type="date", nullable=true)
     */
    private $dtemissproptec;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtemissproptecfinac", type="date", nullable=true)
     */
    private $dtemissproptecfinac;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtemissaogeral", type="date", nullable=true)
     */
    private $dtemissaogeral;

    /**
     * @var string|null
     *
     * @ORM\Column(name="motivoexclusao", type="string", length=255, nullable=true)
     */
    private $motivoexclusao;

    /**
     * @var \Agrega.tbCliente
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbCliente")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cliente_id", referencedColumnName="id")
     * })
     */
    private $cliente;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
