<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbRecurso
 *
 * @ORM\Table(name="agrega.tb_recurso", indexes={@ORM\Index(name="IDX_65CB4F7B35492110", columns={"usuarioatualizacao_id"}), @ORM\Index(name="IDX_65CB4F7B4AD9721D", columns={"tiporecurso_id"}), @ORM\Index(name="IDX_65CB4F7B859422DD", columns={"criadopor_id"}), @ORM\Index(name="IDX_65CB4F7B4BA8D419", columns={"classificacaorecurso_id"}), @ORM\Index(name="IDX_65CB4F7B7ADE2C4", columns={"profissional_id"}), @ORM\Index(name="IDX_65CB4F7BAEC95F8D", columns={"aplicacao_id"})})
 * @ORM\Entity
 */
class tbRecurso
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_recurso_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="armazenamento", type="string", length=255, nullable=true)
     */
    private $armazenamento;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="custo", type="string", length=255, nullable=true)
     */
    private $custo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataaquisicao", type="date", nullable=true)
     */
    private $dataaquisicao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="depreciacao", type="string", length=255, nullable=true)
     */
    private $depreciacao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=501, nullable=true)
     */
    private $descricao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="fabricante", type="string", length=255, nullable=true)
     */
    private $fabricante;

    /**
     * @var string|null
     *
     * @ORM\Column(name="fornecedor", type="string", length=255, nullable=true)
     */
    private $fornecedor;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="garantia", type="date", nullable=true)
     */
    private $garantia;

    /**
     * @var string|null
     *
     * @ORM\Column(name="marca", type="string", length=255, nullable=true)
     */
    private $marca;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome", type="string", length=255, nullable=true)
     */
    private $nome;

    /**
     * @var string|null
     *
     * @ORM\Column(name="numeroserie", type="string", length=100, nullable=true)
     */
    private $numeroserie;

    /**
     * @var int|null
     *
     * @ORM\Column(name="quantidade", type="bigint", nullable=true)
     */
    private $quantidade;

    /**
     * @var string|null
     *
     * @ORM\Column(name="status", type="string", length=255, nullable=true)
     */
    private $status;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="validade", type="date", nullable=true)
     */
    private $validade;

    /**
     * @var float|null
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=true)
     */
    private $valor;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="alteradoem", type="datetime", nullable=true)
     */
    private $alteradoem;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="criadoem", type="datetime", nullable=true)
     */
    private $criadoem;

    /**
     * @var int|null
     *
     * @ORM\Column(name="seqcomboaplicacao", type="bigint", nullable=true)
     */
    private $seqcomboaplicacao;

    /**
     * @var int|null
     *
     * @ORM\Column(name="seqcomboclassificacao", type="bigint", nullable=true)
     */
    private $seqcomboclassificacao;

    /**
     * @var int|null
     *
     * @ORM\Column(name="seqcomborecursos", type="bigint", nullable=true)
     */
    private $seqcomborecursos;

    /**
     * @var string|null
     *
     * @ORM\Column(name="tpunidademedida", type="string", length=255, nullable=true)
     */
    private $tpunidademedida;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;

    /**
     * @var \Agrega.tbTipoRecurso
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbTipoRecurso")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tiporecurso_id", referencedColumnName="id")
     * })
     */
    private $tiporecurso;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="criadopor_id", referencedColumnName="id")
     * })
     */
    private $criadopor;

    /**
     * @var \Agrega.tbClassificacaoRecurso
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbClassificacaoRecurso")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="classificacaorecurso_id", referencedColumnName="id")
     * })
     */
    private $classificacaorecurso;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissional_id", referencedColumnName="id")
     * })
     */
    private $profissional;

    /**
     * @var \Agrega.tbAplicacaoRecurso
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbAplicacaoRecurso")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="aplicacao_id", referencedColumnName="id")
     * })
     */
    private $aplicacao;


}
