<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbRetificacao
 *
 * @ORM\Table(name="agrega.tb_retificacao", indexes={@ORM\Index(name="IDX_8C1315E38BB9F234", columns={"responsavelresposta_id"}), @ORM\Index(name="IDX_8C1315E3E5BB1D9B", columns={"tiporetificacao_id"}), @ORM\Index(name="IDX_8C1315E36BF700BD", columns={"status_id"})})
 * @ORM\Entity
 */
class tbRetificacao
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_retificacao_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="anexocartaretificacao", type="string", length=255, nullable=true)
     */
    private $anexocartaretificacao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="anexodocretificacao", type="string", length=255, nullable=true)
     */
    private $anexodocretificacao;

    /**
     * @var bool|null
     *
     * @ORM\Column(name="cartaentregue", type="boolean", nullable=true)
     */
    private $cartaentregue;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataenvio", type="date", nullable=true)
     */
    private $dataenvio;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataresposta", type="date", nullable=true)
     */
    private $dataresposta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=255, nullable=true)
     */
    private $descricao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricaoproblema", type="string", length=255, nullable=true)
     */
    private $descricaoproblema;

    /**
     * @var int|null
     *
     * @ORM\Column(name="numero", type="bigint", nullable=true)
     */
    private $numero;

    /**
     * @var int|null
     *
     * @ORM\Column(name="projeto", type="bigint", nullable=true)
     */
    private $projeto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="resumoresposta", type="string", length=255, nullable=true)
     */
    private $resumoresposta;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="responsavelresposta_id", referencedColumnName="id")
     * })
     */
    private $responsavelresposta;

    /**
     * @var \Agrega.tbTipoRetificacao
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbTipoRetificacao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tiporetificacao_id", referencedColumnName="id")
     * })
     */
    private $tiporetificacao;

    /**
     * @var \Agrega.tbStatus
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbStatus")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="status_id", referencedColumnName="id")
     * })
     */
    private $status;


}
