<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbServico
 *
 * @ORM\Table(name="agrega.tb_servico", indexes={@ORM\Index(name="IDX_D6380BD335492110", columns={"usuarioatualizacao_id"}), @ORM\Index(name="IDX_D6380BD35CB4216A", columns={"id_area"}), @ORM\Index(name="IDX_D6380BD33170271E", columns={"id_tipo_servico"})})
 * @ORM\Entity
 */
class tbServico
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_servico_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=501, nullable=true)
     */
    private $descricao;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;

    /**
     * @var \Agrega.tbArea
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbArea")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_area", referencedColumnName="id")
     * })
     */
    private $idArea;

    /**
     * @var \Agrega.tbTipoServico
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbTipoServico")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="id_tipo_servico", referencedColumnName="id")
     * })
     */
    private $idTipoServico;


}
