<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbTipoItemProposta
 *
 * @ORM\Table(name="agrega.tb_tipo_item_proposta", indexes={@ORM\Index(name="IDX_BEB4DCFFAE13E077", columns={"proposta_id"})})
 * @ORM\Entity
 */
class tbTipoItemProposta
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_tipo_item_proposta_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=3500, nullable=true)
     */
    private $descricao;

    /**
     * @var int|null
     *
     * @ORM\Column(name="tipoproposta", type="bigint", nullable=true)
     */
    private $tipoproposta;

    /**
     * @var string|null
     *
     * @ORM\Column(name="titulo", type="string", length=1000, nullable=true)
     */
    private $titulo;

    /**
     * @var \Agrega.tbProposta
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProposta")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="proposta_id", referencedColumnName="id")
     * })
     */
    private $proposta;


}
