<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbTrajetoRede
 *
 * @ORM\Table(name="agrega.tb_trajeto_rede", indexes={@ORM\Index(name="IDX_ABA2A5D08A623FAB", columns={"alteradopor_id"}), @ORM\Index(name="IDX_ABA2A5D0844156D0", columns={"cadastradopor_id"})})
 * @ORM\Entity
 */
class tbTrajetoRede
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_trajeto_rede_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datacadastro", type="date", nullable=true)
     */
    private $datacadastro;

    /**
     * @var string|null
     *
     * @ORM\Column(name="descricao", type="string", length=255, nullable=true)
     */
    private $descricao;

    /**
     * @var int|null
     *
     * @ORM\Column(name="ordem", type="bigint", nullable=true)
     */
    private $ordem;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pontofim", type="string", length=255, nullable=true)
     */
    private $pontofim;

    /**
     * @var string|null
     *
     * @ORM\Column(name="pontoinicio", type="string", length=255, nullable=true)
     */
    private $pontoinicio;

    /**
     * @var int|null
     *
     * @ORM\Column(name="projeto", type="bigint", nullable=true)
     */
    private $projeto;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataalteracao", type="date", nullable=true)
     */
    private $dataalteracao;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="alteradopor_id", referencedColumnName="id")
     * })
     */
    private $alteradopor;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="cadastradopor_id", referencedColumnName="id")
     * })
     */
    private $cadastradopor;


}
