<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbUsuario
 *
 * @ORM\Table(name="agrega.tb_usuario", indexes={@ORM\Index(name="IDX_F515C84257291544", columns={"perfil_id"}), @ORM\Index(name="IDX_F515C84235492110", columns={"usuarioatualizacao_id"})})
 * @ORM\Entity
 */
class tbUsuario
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_usuario_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var bool
     *
     * @ORM\Column(name="ativo", type="boolean", nullable=false)
     */
    private $ativo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataatualizacao", type="date", nullable=true)
     */
    private $dataatualizacao;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainclusao", type="date", nullable=true)
     */
    private $datainclusao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="email", type="string", length=255, nullable=true)
     */
    private $email;

    /**
     * @var string|null
     *
     * @ORM\Column(name="funcao", type="string", length=255, nullable=true)
     */
    private $funcao;

    /**
     * @var string|null
     *
     * @ORM\Column(name="login", type="string", length=255, nullable=true)
     */
    private $login;

    /**
     * @var string|null
     *
     * @ORM\Column(name="nome", type="string", length=255, nullable=true)
     */
    private $nome;

    /**
     * @var string|null
     *
     * @ORM\Column(name="senha", type="string", length=255, nullable=true)
     */
    private $senha;

    /**
     * @var string|null
     *
     * @ORM\Column(name="setor", type="string", length=255, nullable=true)
     */
    private $setor;

    /**
     * @var string|null
     *
     * @ORM\Column(name="telefone", type="string", length=255, nullable=true)
     */
    private $telefone;

    /**
     * @var \Agrega.tbPerfil
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbPerfil")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="perfil_id", referencedColumnName="id")
     * })
     */
    private $perfil;

    /**
     * @var \Agrega.tbUsuario
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbUsuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="usuarioatualizacao_id", referencedColumnName="id")
     * })
     */
    private $usuarioatualizacao;


}
