<?php

namespace App\Doctrine\_Backup\Agrega;

use Doctrine\ORM\Mapping as ORM;

/**
 * Agrega.tbVerificacaoProfissional
 *
 * @ORM\Table(name="agrega.tb_verificacao_profissional", indexes={@ORM\Index(name="IDX_E97382BDACCBEA07", columns={"profissionalevctgal_id"}), @ORM\Index(name="IDX_E97382BDE811FA8D", columns={"profissionalverificacao_id"}), @ORM\Index(name="IDX_E97382BDEB3BC75", columns={"profissionalepi_id"}), @ORM\Index(name="IDX_E97382BD10B87F06", columns={"profissionalmapas_id"})})
 * @ORM\Entity
 */
class tbVerificacaoProfissional
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="SEQUENCE")
     * @ORM\SequenceGenerator(sequenceName="agrega.tb_verificacao_profissional_id_seq", allocationSize=1, initialValue=1)
     */
    private $id;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dataentrega", type="date", nullable=true)
     */
    private $dataentrega;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datafimcampo", type="date", nullable=true)
     */
    private $datafimcampo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainiciocampo", type="date", nullable=true)
     */
    private $datainiciocampo;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacaoplanejamento", type="string", length=1000, nullable=true)
     */
    private $observacaoplanejamento;

    /**
     * @var int|null
     *
     * @ORM\Column(name="profissionaldadoscampo_id", type="bigint", nullable=true)
     */
    private $profissionaldadoscampoId;

    /**
     * @var int|null
     *
     * @ORM\Column(name="profissionalmfse_id", type="bigint", nullable=true)
     */
    private $profissionalmfseId;

    /**
     * @var int|null
     *
     * @ORM\Column(name="profissionalro_id", type="bigint", nullable=true)
     */
    private $profissionalroId;

    /**
     * @var int|null
     *
     * @ORM\Column(name="projeto_id", type="bigint", nullable=true)
     */
    private $projetoId;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datafimplanejamento", type="date", nullable=true)
     */
    private $datafimplanejamento;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="datainicioplanejamento", type="date", nullable=true)
     */
    private $datainicioplanejamento;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtfimplanejamento", type="date", nullable=true)
     */
    private $dtfimplanejamento;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtinicioplanejamento", type="date", nullable=true)
     */
    private $dtinicioplanejamento;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtfimcampo", type="date", nullable=true)
     */
    private $dtfimcampo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="dtiniciocampo", type="date", nullable=true)
     */
    private $dtiniciocampo;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalevctgal_id", referencedColumnName="id")
     * })
     */
    private $profissionalevctgal;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalverificacao_id", referencedColumnName="id")
     * })
     */
    private $profissionalverificacao;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalepi_id", referencedColumnName="id")
     * })
     */
    private $profissionalepi;

    /**
     * @var \Agrega.tbProfissional
     *
     * @ORM\ManyToOne(targetEntity="Agrega.tbProfissional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissionalmapas_id", referencedColumnName="id")
     * })
     */
    private $profissionalmapas;


}
